/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWParticipantList;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkBasket;
import filenet.vw.base.VWObjectNotFoundException;
import filenet.vw.server.InternalVWWorkBasket;
import filenet.vw.server.WorkBasketRef;
import java.io.Serializable;

public class VWRole
implements Serializable {
    private static final long serialVersionUID = 7424L;
    protected int revision = -1;
    protected String name = null;
    protected String description = null;
    protected String homePageURL = null;
    protected VWAttributeInfo attributes = null;
    protected String applicationSpaceName = null;
    protected WorkBasketReference[] workBasketRefs = null;
    private VWParticipant[] members = null;
    protected int objId = -1;
    protected VWSession session = null;
    private String m_desc = null;

    protected static String _get_FILE_DATE() {
        return "$Date: 2010-06-29 23:32:00 GMT $";
    }

    protected static String _get_FILE_AUTHOR() {
        return "$Author: Van Vuong;5D6184897;vanvuong1@us.ibm.com (vvuong) $";
    }

    protected static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/12 $";
    }

    protected VWRole(int revision, String name, String description, String homePageURL, VWAttributeInfo attributes, String applicationSpaceName, WorkBasketRef[] workbaskets, int objId, VWParticipant[] participantArray) {
        this.revision = revision;
        this.name = name;
        this.description = description;
        this.homePageURL = homePageURL;
        this.attributes = attributes;
        this.applicationSpaceName = applicationSpaceName;
        this.workBasketRefs = this.getWorkBasketsFromServer(workbaskets);
        this.objId = objId;
        this.members = participantArray;
    }

    public VWRole(VWSession theSession, String roleName, String applicationSpaceName) {
        this.session = theSession;
        this.name = roleName;
        this.applicationSpaceName = applicationSpaceName;
    }

    private WorkBasketReference[] getWorkBasketsFromServer(WorkBasketRef[] wbs) {
        int nWbs;
        int n = nWbs = wbs == null ? 0 : wbs.length;
        if (nWbs == 0) {
            return null;
        }
        WorkBasketReference[] resWorkBasketRefs = new WorkBasketReference[nWbs];
        for (int i = 0; i < nWbs; ++i) {
            resWorkBasketRefs[i] = new WorkBasketReference(wbs[i].queueName, wbs[i].workBasketName, this);
        }
        return resWorkBasketRefs;
    }

    protected void setVWSession(VWSession session) {
        this.session = session;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getName() {
        try {
            if (this.session != null) {
                return this.session.translate(this.name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.name;
    }

    public String getAuthoredName() {
        return this.getAuthoredName(this.name);
    }

    private String getAuthoredName(String iname) {
        try {
            if (this.session != null) {
                return this.session.translateToAuthored(iname);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iname;
    }

    public int getId() {
        return this.objId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHomePageURL() {
        return this.homePageURL;
    }

    public String getApplicationSpaceName() {
        return this.applicationSpaceName;
    }

    public VWAttributeInfo getAttributeInfo() {
        return this.attributes;
    }

    public VWWorkBasket fetchWorkBasket(String queueName, String workBasketName) throws VWException {
        String wbName;
        this.verifyRetrievedFromServer();
        if (this.session == null) {
            throw new VWException("vw.api.role.invalidState", "Invalid State:  the Role does not have an associated VWSession.");
        }
        workBasketName = this.getAuthoredName(workBasketName);
        queueName = this.getAuthoredName(queueName);
        if (workBasketName == null) {
            return null;
        }
        VWQueue queue = this.session.getQueue(queueName);
        InternalVWWorkBasket _workBasket = this.session.cmdSession.fetchMyWorkBasket(this.name, this.applicationSpaceName, queue.classId, workBasketName);
        String string = wbName = _workBasket != null && _workBasket.wbDef != null ? _workBasket.wbDef.getName() : null;
        if (wbName != null && wbName.trim().equals(workBasketName)) {
            return VWWorkBasket.getVWWorkBasket(_workBasket, queue);
        }
        throw new VWObjectNotFoundException(VWQueue.VSTR_NOWB.toString(workBasketName), -1L, 2);
    }

    public VWWorkBasket[] fetchWorkBaskets() throws VWException {
        this.verifyRetrievedFromServer();
        if (this.session == null) {
            throw new VWException("vw.api.role.invalidState", "Invalid State:  the Role does not have an associated VWSession.");
        }
        InternalVWWorkBasket[] _workBaskets = this.session.cmdSession.fetchMyWorkBaskets(this.name, this.applicationSpaceName);
        int nWBs = _workBaskets == null ? 0 : _workBaskets.length;
        VWWorkBasket[] res = new VWWorkBasket[nWBs];
        for (int i = 0; i < nWBs; ++i) {
            VWQueue queue = this.session.getQueue(_workBaskets[i].wbDef.getQueueName());
            res[i] = VWWorkBasket.getVWWorkBasket(_workBaskets[i], queue);
        }
        return res;
    }

    public WorkBasketReference[] getWorkBasketReferences() {
        return this.workBasketRefs;
    }

    public VWParticipant[] getParticipants() throws VWException {
        this.verifyRetrievedFromServer();
        return this.members;
    }

    public VWParticipant[] refreshParticipants() throws VWException {
        this.verifyRetrievedFromServer();
        if (this.session == null) {
            throw new VWException("vw.api.role.invalidState", "The participants could not be retrieved. This role is not currently associated with a session (VWSession object). /nEnsure that a session is active.");
        }
        VWParticipantList parList = this.session.cmdSession.fetchRoleParticipantsEx(this.name, this.applicationSpaceName, true);
        this.members = parList != null ? parList.fetchedObjects : null;
        return this.members;
    }

    public VWParticipant[] saveParticipants(String[] removeParticipantNames, String[] addParticipantNames) throws VWException {
        if (this.session == null) {
            throw new VWException("vw.api.role.invalidState", "Invalid State:  the Role does not have an associated VWSession.");
        }
        VWParticipantList parList = this.session.cmdSession.setRolePartipants(this.applicationSpaceName, this.name, addParticipantNames, removeParticipantNames);
        this.members = parList != null ? parList.fetchedObjects : null;
        return this.members;
    }

    protected String translateWorkBasketName(String name) throws VWException {
        return this.translateName(name);
    }

    private String translateName(String name) throws VWException {
        if (this.session == null || name == null) {
            return name;
        }
        return this.session.translate(name);
    }

    public String toString() {
        if (this.m_desc == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("VwRole: ").append(this.name).append("[").append(this.revision).append("]").append(", ").append(this.description).append(", ").append(this.homePageURL).append(", ").append(this.applicationSpaceName);
            this.getAttributesString(this.attributes, buf);
            this.m_desc = buf.toString();
        }
        return this.m_desc;
    }

    protected void getAttributesString(VWAttributeInfo attr, StringBuffer buf) {
        try {
            if (attr == null) {
                buf.append(".  Null Attributes");
                return;
            }
            buf.append("\nAttributes=");
            String[] names = attr.getAttributeNames();
            int nNames = names == null ? 0 : names.length;
            for (int i = 0; i < nNames; ++i) {
                buf.append("\n").append(names[i]).append("=").append(attr.getFieldValue(names[i]));
            }
        }
        catch (Exception e) {
            String s = VWException.DescribeThrowableAndItsCause(e);
            buf.append("\nFailed to get attributes, ex=").append(s).append("\n");
        }
    }

    private void verifyRetrievedFromServer() throws VWException {
        if (this.revision == -1 && this.objId == -1) {
            throw new VWException("vw.api.role.notRetrievedFromServer", "Invalid State:  this Role was not retrieved from the PE server.");
        }
    }

    public static class WorkBasketReference
    implements Serializable {
        private static final long serialVersionUID = 7424L;
        private String qName;
        private String wbAuthoredName;
        private VWRole role;
        private String desc = "";

        public String getQueueName() throws VWException {
            if (this.role != null) {
                return this.role.translateName(this.qName);
            }
            return this.qName;
        }

        public String getWorkBasketName() throws VWException {
            if (this.role != null) {
                return this.role.translateWorkBasketName(this.wbAuthoredName);
            }
            return this.wbAuthoredName;
        }

        public String getWorkBasketAuthoredName() {
            return this.wbAuthoredName;
        }

        protected WorkBasketReference(String qName, String wbName, VWRole r) {
            this.qName = qName;
            this.wbAuthoredName = wbName;
            this.role = r;
            this.desc = qName + ":" + wbName;
        }

        public String toString() {
            return this.desc;
        }
    }
}

